--[[Copyright (C) Squigglze, 2025]]

--===============================================================
     -- ADD CANNABIS TO ANIMAL FOOD --
--===============================================================

FoliageSystem.loadMapData = Utils.overwrittenFunction(FoliageSystem.loadMapData, function (self, superFunc, mapXmlFile, missionInfo, baseDirectory, ...)
	superFunc(self, mapXmlFile, missionInfo, baseDirectory, ...)

	local animalFoodSystem = g_currentMission.animalFoodSystem

	for i, animalTypeName in ipairs({
		"HORSE",
		"PIG",
		"SHEEP",
		"CHICKEN",
		"COW",
		"GOAT"
	}) do
		local animalTypeIndex = g_currentMission.animalSystem:getTypeIndexByName(animalTypeName)

		if animalTypeIndex ~= nil then
			local animalFood = animalFoodSystem.animalTypeIndexToFood[animalTypeIndex]

			if animalFood ~= nil then
				for _, foodGroup in ipairs(animalFood.groups) do
					for _, fillTypeIndex in ipairs(foodGroup.fillTypes) do
						if fillTypeIndex == FillType.POTATO then
							table.insert(foodGroup.fillTypes, FillType.CANNABIS)

							break
						end
					end
				end

				if animalTypeName == "HORSE" then
					local foodGroup = {
						title = g_i18n:getText("fillTypeGroup_earth"),
						productionWeight = 0.05,
						eatWeight = 0.05,
						fillTypes = {
							FillType.CANNABIS
						}
					}

					table.insert(animalFood.groups, foodGroup)
				end
				
				if animalTypeName == "SHEEP" then
					local foodGroup = {
						title = g_i18n:getText("fillTypeGroup_earth"),
						productionWeight = 0.05,
						eatWeight = 0.05,
						fillTypes = {
							FillType.CANNABIS
						}
					}

					table.insert(animalFood.groups, foodGroup)
				end
				
				if animalTypeName == "CHICKEN" then
					local foodGroup = {
						title = g_i18n:getText("fillTypeGroup_grain"),
						productionWeight = 0.05,
						eatWeight = 0.05,
						fillTypes = {
							FillType.CANNABIS
						}
					}

					table.insert(animalFood.groups, foodGroup)
				end
				
				if animalTypeName == "COW" then
					local foodGroup = {
						title = g_i18n:getText("fillTypeGroup_grass"),
						productionWeight = 0.05,
						eatWeight = 0.05,
						fillTypes = {
							FillType.CANNABIS
						}
					}

					table.insert(animalFood.groups, foodGroup)
				end
				
				if animalTypeName == "GOAT" then
					local foodGroup = {
						title = g_i18n:getText("fillTypeGroup_grass"),
						productionWeight = 0.05,
						eatWeight = 0.05,
						fillTypes = {
							FillType.CANNABIS
						}
					}

					table.insert(animalFood.groups, foodGroup)
				end

				if animalFood.consumptionType == AnimalFoodSystem.FOOD_CONSUME_TYPE_PARALLEL then
					local sumWeigths = 0
					local eatWeights = 0

					for _, foodGroup in pairs(animalFood.groups) do
						sumWeigths = sumWeigths + foodGroup.productionWeight
						eatWeights = eatWeights + foodGroup.eatWeight
					end

					for _, foodGroup in pairs(animalFood.groups) do
						if sumWeigths > 0 then
							foodGroup.productionWeight = foodGroup.productionWeight / sumWeigths
						end

						if eatWeights > 0 then
							foodGroup.eatWeight = foodGroup.eatWeight / eatWeights
						end
					end
				end
			end

			if animalFoodSystem.animalMixtures[animalTypeIndex] ~= nil then
				for _, mixtureFillTypeIndex in ipairs(animalFoodSystem.animalMixtures[animalTypeIndex]) do
					local mixture = animalFoodSystem.mixtureFillTypeIndexToMixture[mixtureFillTypeIndex]

					if mixture ~= nil then
						for _, ingredient in ipairs(mixture.ingredients) do
							for _, fillTypeIndex in ipairs(ingredient.fillTypes) do
								if fillTypeIndex == FillType.POTATO then
									table.insert(ingredient.fillTypes, FillType.CANNABIS)

									break
								end
							end
						end
					end
				end
			end
		end
	end
end)
