--
-- ATMEvent
--
-- @author Manuel Leithner
-- @date   02/03/23
-- @updated for Farming Simulator 25
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

ATMEvent = {}
local ATMEvent_mt = Class(ATMEvent, Event)

InitEventClass(ATMEvent, "ATMEvent")

function ATMEvent.emptyNew()
    local self = Event.new(ATMEvent_mt)
    return self
end

function ATMEvent.new(placeable, farmId)
    local self = ATMEvent.emptyNew()
    self.placeable = placeable
    self.farmId = farmId
    return self
end

function ATMEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.placeable)
    streamWriteUIntN(streamId, self.farmId, FarmManager.FARM_ID_SEND_NUM_BITS)
end

function ATMEvent:readStream(streamId, connection)
    self.placeable = NetworkUtil.readNodeObject(streamId)
    self.farmId = streamReadUIntN(streamId, FarmManager.FARM_ID_SEND_NUM_BITS)
    self:run(connection)
end

function ATMEvent:run(connection)
    assert(not connection:getIsServer(), "ATMEvent is client to server only")
    if self.placeable ~= nil and self.placeable.requestMoney ~= nil then
        self.placeable:requestMoney(self.farmId)
    end
end

function ATMEvent.sendEvent(placeable, farmId)
    if g_currentMission:getIsServer() then
        placeable:requestMoney(farmId)
    else
        local event = ATMEvent.new(placeable, farmId)
        g_client:getServerConnection():sendEvent(event)
    end
end
