UniversalCircleMissionHotspot = {}
local UniversalCircleMissionHotspot_mt = Class(UniversalCircleMissionHotspot, MapHotspot)

function UniversalCircleMissionHotspot.new(customMt)	
	local self = MapHotspot.new(customMt or UniversalCircleMissionHotspot_mt);
	local scaleWidth, scaleHeight = getNormalizedScreenValues(50, 50);
	self.width = scaleWidth;
	self.height = scaleHeight;
	self.circle = g_overlayManager:createOverlay("mapHotspots.circle", 0, 0, self.width, self.height);
	self.circle:setColor(0.5089, 0.016, 0.016, 1);
	self.worldRadius = 50;
	self.forceNoRotation = true;
	return self;
end;

function UniversalCircleMissionHotspot:delete()
	UniversalCircleMissionHotspot:superClass().delete(self);
	if self.circle ~= nil then
		self.circle:delete();
		self.circle = nil;
	end;
end;

function UniversalCircleMissionHotspot:setWorldRadius(worldRadius)
	self.worldRadius = worldRadius;
end;

function UniversalCircleMissionHotspot:postUpdate(dt)
	local ingameMap = g_currentMission.hud:getIngameMap();
	local mapWidth, mapHeight = ingameMap.layout:getMapSize();
	local width = self.worldRadius / ingameMap.worldSizeX * mapWidth;
	local height = self.worldRadius / ingameMap.worldSizeZ * mapHeight;
	if self.circle ~= nil then
		self.circle:setDimension(width, height);
	end;
end;

function UniversalCircleMissionHotspot:getWidth()
	return self.circle == nil and 0 or self.circle.width;
end;

function UniversalCircleMissionHotspot:getHeight()
	return self.circle == nil and 0 or self.circle.height;
end;

function UniversalCircleMissionHotspot:getDimension()
	if self.circle == nil then
		return 0, 0;
	else
		return self.circle.width, self.circle.height;
	end;
end;

function UniversalCircleMissionHotspot:setScale(scale) end;

function UniversalCircleMissionHotspot:getCategory()
	return MapHotspot.CATEGORY_MISSION;
end;

function UniversalCircleMissionHotspot:getIsPersistent()
	return false;
end;

function UniversalCircleMissionHotspot:getRenderLast()
	return false;
end;

function UniversalCircleMissionHotspot:render(x, y, rotation, small)
	local circle = self.circle;
	if circle ~= nil then
		circle:setPosition(x, y);
		circle:setColor(nil, nil, nil, IngameMap.alpha);
		circle:render();
		local _ = x + circle.width * 0.5;
		local _ = y + circle.height * 0.5;
	end;
end;
