
-- @Author: Ragman2414
-- @Version: 1.0.0.0


ContractPlusSettings = {};
ContractPlusSettings.name = g_currentModName;
ContractPlusSettings.modDirectory = g_currentModDirectory
source(g_currentModDirectory .. "loadContractSettingsEvent.lua")

ContractPlusSettings.tooltipId = 1
ContractPlusSettings.settingTitleId = 2

function ContractPlusSettings.init()
    InGameMenuSettingsFrame.onFrameOpen = Utils.appendedFunction(InGameMenuSettingsFrame.onFrameOpen, ContractPlusSettings.initSettingsGui)

    Mission00.loadMission00Finished = Utils.appendedFunction(Mission00.loadMission00Finished, ContractPlusSettings.loadSettingsXML)
    FSCareerMissionInfo.saveToXMLFile = Utils.appendedFunction(FSCareerMissionInfo.saveToXMLFile, ContractPlusSettings.saveSettingsXML)
    FSBaseMission.onConnectionFinishedLoading = Utils.appendedFunction(FSBaseMission.onConnectionFinishedLoading, ContractPlusSettings.loadSettingsFromServer2)
end

function ContractPlusSettings.initSettingsGui(self)
    ---Just check for missionPerFarm
    if self.missionPerFarm == nil then

        -- Section Header
        local title = self.gameSettingsLayout.elements[7]:clone()
        title:applyProfile("fs25_settingsSectionHeader", true)
        title:setText(ContractPlusSettings:getText("r_contract_settings_title"))
        title.focusChangeData={}
        title.focusId = FocusManager.serveAutoFocusId()

        self.gameSettingsLayout:addElement(title)

        local target = g_r_contracts

        local optionClone = self.economicDifficulty:clone()
        optionClone.target = target
        optionClone.onClickCallback = ContractPlusSettings.onContractstStateChanged
        optionClone.buttonLRChange = ContractPlusSettings.onContractstStateChanged
        optionClone.texts[1] = "0"
        optionClone.texts[2] = "1"
        optionClone.texts[3] = "2"
        optionClone.texts[4] = "3"
        optionClone.texts[5] = "4"
        optionClone.texts[6] = "5"
        optionClone.texts[7] = "6"
        optionClone.texts[8] = "7"
        optionClone.texts[9] = "8"
        optionClone.texts[10] = "9"
        optionClone.texts[11] = "10"
        optionClone.texts[12] = "Max"

        self.missionPerFarm = optionClone:clone()

        local state = 4
        if(g_r_contracts.missionPerFarm ~= nil) then
            state = g_r_contracts.missionPerFarm
        end
        self.missionPerFarm:setState(state)

        ContractPlusSettings:addOptionToLayout(
            self.gameSettingsLayout,
            self.missionPerFarm,
            "missionPerFarm",
            "r_missionPerFarm",
            self.gameSettingsLayout.elements[5]
        )

        --
        self.allowClearAdd = self.checkTraffic:clone()
        self.allowClearAdd.onClickCallback = ContractPlusSettings.onContractstStateChanged
        self.allowClearAdd.target = target


        local allowClearAddState = 2
        if(g_r_contracts.allowClearAdd ~= nil) then
                allowClearAddState = g_r_contracts.allowClearAdd
        end
        self.allowClearAdd:setState(allowClearAddState, true, true)


        ContractPlusSettings:addOptionToLayout(
            self.gameSettingsLayout,
            self.allowClearAdd,
            "allowClearAdd",
            "r_allowClearAdd",
            self.gameSettingsLayout.elements[5]
        )

        --
        self.leaseVehicle = self.checkTraffic:clone()
        self.leaseVehicle.onClickCallback = ContractPlusSettings.onContractstStateChanged
        self.leaseVehicle.target = target

        ContractPlusSettings:addOptionToLayout(
            self.gameSettingsLayout,
            self.leaseVehicle,
            "leaseVehicle",
            "r_leaseVehicle",
            self.gameSettingsLayout.elements[5]
        )

        local leaseVehicleState = 2
        if(g_r_contracts.leaseVehicle ~= nil) then
                leaseVehicleState = g_r_contracts.leaseVehicle
        end
        self.leaseVehicle:setState(leaseVehicleState, true, true)

        self.gameSettingsLayout:invalidateLayout()
    end

end

function ContractPlusSettings:addOptionToLayout(gameSettingsLayout, cloneElement, id, textId, settingsClone)
    cloneElement.id = id

    local toolTip = cloneElement.elements[1]

    toolTip.text = ContractPlusSettings:getText(textId.."_tooltip")
    toolTip.sourceText = ContractPlusSettings:getText(textId.."_tooltip")


    local optionTitle = settingsClone.elements[2]:clone()
    optionTitle.id = id.."Title"
    optionTitle:applyProfile("fs25_settingsMultiTextOptionTitle", true)
    optionTitle:setText(ContractPlusSettings:getText(textId))

    local optionContainer = settingsClone:clone()
    optionContainer.id = id.."Container"

    optionContainer:applyProfile("fs25_multiTextOptionContainer", true)
    for key, v in pairs(optionContainer.elements) do
        optionContainer.elements[key] = nil
    end

    optionContainer:addElement(optionTitle)
    optionContainer:addElement(cloneElement)
    gameSettingsLayout:addElement(optionContainer)
end

function ContractPlusSettings:getText(key)
    return g_i18n.modEnvironments[ContractPlusSettings.name].texts[key]
end

function ContractPlusSettings:onContractstStateChanged(state,x,y,z)
    g_client:getServerConnection():sendEvent(ChangeContractSettingsEvent.new(x.id, state))
end


function ContractPlusSettings.loadSettingsXML(mission, node)
    ContractPlusSettings.defaultValues();
    if mission:getIsServer() then
        if mission.missionInfo.savegameDirectory ~= nil and fileExists(mission.missionInfo.savegameDirectory .. "/r_contracts.xml") then
            local xmlFile = XMLFile.load("RContractsXML", mission.missionInfo.savegameDirectory .. "/r_contracts.xml")
            if xmlFile ~= nil then
                g_r_contracts.leaseVehicle = xmlFile:getFloat("r_contracts.leaseVehicle")
                g_r_contracts.missionPerFarm = xmlFile:getFloat("r_contracts.missionPerFarm")
                g_r_contracts.allowClearAdd = xmlFile:getFloat("r_contracts.allowClearAdd")
                xmlFile:delete()
            end
        end
    end
end

function ContractPlusSettings.loadSettingsFromServer2()
    g_client:getServerConnection():sendEvent(LoadContractSettingsEvent.new())

end

function ContractPlusSettings.saveSettingsXML(missionInfo)
    if(g_r_contracts == nil) then
        return
    end
    local xmlFile = XMLFile.create("RContractsXML", missionInfo.savegameDirectory .. "/r_contracts.xml", "r_contracts")
    if xmlFile ~= nil then
        xmlFile:setFloat("r_contracts.leaseVehicle", g_r_contracts.leaseVehicle)
        xmlFile:setFloat("r_contracts.missionPerFarm",g_r_contracts.missionPerFarm)
        xmlFile:setFloat("r_contracts.allowClearAdd", g_r_contracts.allowClearAdd)
        xmlFile:save()
    end

end

function ContractPlusSettings.defaultValues()
        if(g_r_contracts == nil) then
            g_r_contracts = {}
        end
        if(g_r_contracts.leaseVehicle == nil or g_r_contracts.leasesVehicle == 0) then
            g_r_contracts.leaseVehicle = 2
        end

        if(g_r_contracts.missionPerFarm == nil) then
            g_r_contracts.missionPerFarm = 4
        end

        if(g_r_contracts.allowClearAdd == nil or g_r_contracts.allowClearAdd == 0) then
            g_r_contracts.allowClearAdd = 2
        end
    end


ContractPlusSettings.init()
