-- dynamicLowering 
-- For soilwork implements to simulate them being pulled into the ground rather than falling into the ground.
-- Base from modelleicher (https://www.youtube.com/modelleicher) 
-- Authors: SMI Modding Team (Nicola)
-- Game version: Farming Simulator 25
-- Version: 1.0 - 24.11.2024

-- This script can be used by SMI Modding Team and Farming Agency ONLY

dynamicLowering = {}

function dynamicLowering.prerequisitesPresent(specializations)
    return true
end

function dynamicLowering.registerEventListeners(vehicleType)
	SpecializationUtil.registerEventListener(vehicleType, "onLoad", dynamicLowering)
	SpecializationUtil.registerEventListener(vehicleType, "onUpdate", dynamicLowering)
	SpecializationUtil.registerEventListener(vehicleType, "onPostLoad", dynamicLowering)
	SpecializationUtil.registerEventListener(vehicleType, "onSetLowered", dynamicLowering)
end

function dynamicLowering.initSpecialization()
    local schema = Vehicle.xmlSchema
    schema:setXMLSpecializationType("dynamicLowering")

    schema:register(XMLValueType.STRING, "vehicle.dynamicLowering#animationName", "Animation name")

    schema:setXMLSpecializationType()
end


function dynamicLowering:onLoad(savegame)
	local xmlFile = self.xmlFile
	self.spec_dynamicLowering = {}
	local spec = self.spec_dynamicLowering

	local animationName = xmlFile:getValue("vehicle.dynamicLowering#animationName")

	if animationName ~= "" and animationName ~= nil then
		spec.animationName = animationName
	else
		spec = nil
	end

end

function dynamicLowering:onPostLoad(savegame)
	local spec = self.spec_dynamicLowering
	if spec ~= nil then
		self:playAnimation(spec.animationName, 1, self:getAnimationTime(spec.animationName), true)
	end
end

local function has_value (tab, val)
    for _, value in ipairs(tab) do
        if value == val then
            return true
        end
    end

    return false
end

function dynamicLowering:onSetLowered(lowered)
	local spec = self.spec_dynamicLowering
	if spec ~= nil and not lowered then
		self:stopAnimation(spec.animationName, true);
		self:playAnimation(spec.animationName, 0.3, self:getAnimationTime(spec.animationName), true)
	end

	local brand_index = self:getBrand()
	local brand = g_brandManager:getBrandByIndex(brand_index)
	local brands = { "MGP", "ERMO", "OCRAMA", "EUROSPAND", "PASTO", "RAPISARDA", "VALENTINI" }
	if not has_value(brands, brand.name) then
		self.spec_dynamicLowering = nil
	end
end


function dynamicLowering:onUpdate(dt) 
	local spec = self.spec_dynamicLowering
	if spec ~= nil then
		local lastSpeed = self:getLastSpeed(true);
		local enabled = self:getDoGroundManipulation() and self:getIsOnField()

		if enabled and self:getIsLowered() and self:getAnimationTime(spec.animationName) > 0 then
			self:playAnimation(spec.animationName, -(0.05 * lastSpeed), nil, true)
		end
	end
end