-- Injector for AutoStrawSwath
--
-- @author  Shaydera
-- @history     v1.0.0.0 - 2024-11-29 - Initial version
--
-- @Descripion: Automatically activates the straw swath of a combine harvester when a suitable crop type is harvested.
-- Copyright (C) Shaydera, All Rights Reserved.

local specName = "autoStrawSwath"
local modName = g_currentModName
local debug = true

TypeManager.finalizeTypes = Utils.prependedFunction(TypeManager.finalizeTypes, function(self, ...)
    if self.typeName == "vehicle" then
        for typeName, typeEntry in pairs(self:getTypes()) do
            if SpecializationUtil.hasSpecialization(Combine, typeEntry.specializations) and not SpecializationUtil.hasSpecialization(AutoStrawSwath, typeEntry.specializations) then
                self:addSpecialization(typeName, modName.."."..specName)
                if debug then
                    print("Added "..specName.." to "..typeName)
                end
            end
        end
    end
end)
